import pandas as pd
import numpy as np
from sklearn.decomposition import PCA

class CoupleData:
    def __init__(self, size) -> None:
        self.size = size
        self._U(); self._A1(); self._A2(); self._A3();self._A4();self._A5();self._Y1();self._Y2();self._Y3();self._Y4()
        self._pddata()
        
    def _U(self,) -> None:
        self.U = np.random.uniform(-1,1,size=self.size)
    
    def _A1(self,) -> None:
        self.A1 = 0.5*(self.U+3) + np.random.normal(0,1,size=self.size)
        
    def _A2(self,) -> None:
        self.A2 = 0.5*(np.tanh(self.U)+3) + np.random.normal(0,1,size=self.size)

    def _A3(self,) -> None:
        self.A3 = 0.5*(np.sin(np.pi/8*self.U)+3) + np.random.normal(0,1,size=self.size)

    def _A4(self,) -> None:
        self.A4 = 0.5*(1.0/(1.0+np.exp(self.U))+3) + np.random.normal(0,1,size=self.size)

    def _A5(self,) -> None:
        self.A5 = 0.5*(np.cos(np.pi/8*self.U)+3) + np.random.normal(0,1,size=self.size)


    def _Y1(self,) -> None:
        self.Y1 = 2*np.sin(1.4*self.A1 +2*self.A3**2)+0.5*(self.A2+self.A4**2+self.A5)+self.A3**3 + self.U + np.random.normal(0,1,size=self.size)

    def _Y2(self,) -> None:
        self.Y2 = -2*np.cos(1.8*self.A2)+1.5*self.A4**2+ self.U + np.random.normal(0,1,size=self.size)

    def _Y3(self,) -> None:
        self.Y3 = 0.7*self.A3**2+ 1.2*self.A4 + self.U + np.random.normal(0,1,size=self.size)

    def _Y4(self,) -> None:
        self.Y4 = 0.2*np.exp(-self.A1+1)+ 1.4*self.A5**2 + self.U + np.random.normal(0,1,size=self.size)


    def _pddata(self,) -> pd.DataFrame:
        df = pd.DataFrame({'U':self.U})
        df['A1'] = self.A1
        df['A2'] = self.A2
        df['A3'] = self.A3
        df['A4'] = self.A4
        df['A5'] = self.A5
        df['Y1'] = self.Y1
        df['Y2'] = self.Y2
        df['Y3'] = self.Y3
        df['Y4'] = self.Y4
        self.df = df


class Experiment1:
    def __init__(self, size,causal,beta) -> None:
        self.size = size
        self.causal = causal
        self.beta = beta
        self._U(); self._A(); self._W(); self._Y()
        self._pddata()
        
    def _U(self,) -> None:
        self.U = np.random.normal(0,1,size=self.size)
    
    def _A(self,) -> None:
        self.A = self.U + np.random.normal(0,1,size=self.size)
        
    def _W(self,) -> None:
        self.W = self.U + np.random.normal(0,1,size=self.size)

    def _Y(self,) -> None:
        if self.causal == True:
            self.Y = self.A + self.W + self.beta*self.U + np.random.normal(0,1,size=self.size)
        else:
            self.Y = self.W + self.beta*self.U + np.random.normal(0,1,size=self.size)

    def _pddata(self,) -> pd.DataFrame:
        df = pd.DataFrame({'U':self.U})
        df['A'] = self.A
        df['W'] = self.W
        df['Y'] = self.Y
        self.df = df



class Experiment2:
    def __init__(self, size,causal,beta) -> None:
        self.size = size
        self.causal = causal
        self.beta = beta
        self._U(); self._A(); self._W(); self._Y()
        self._pddata()
        
    def _U(self,) -> None:
        self.U = np.random.normal(0,1,size=self.size)
    
    def _A(self,) -> None:
        self.A = self.U + np.random.normal(0,1,size=self.size)
        
    def _W(self,) -> None:
        self.W = self.U + np.random.normal(0,1,size=self.size)

    def _Y(self,) -> None:
        if self.causal == True:
            self.Y = self.A + self.W + self.beta*np.tanh(self.U) + np.random.normal(0,1,size=self.size)
        else:
            self.Y = self.W + self.beta*np.tanh(self.U) + np.random.normal(0,1,size=self.size) 

    def _pddata(self,) -> pd.DataFrame:
        df = pd.DataFrame({'U':self.U})
        df['A'] = self.A
        df['W'] = self.W
        df['Y'] = self.Y
        self.df = df


class Experiment3:
    def __init__(self,size,beta,causal=False) -> None:
        self.size = size
        self.causal = causal
        self.beta = beta
        self._U(); self._A(); self._W(); self._Y()
        self._pddata()
        
    def _U(self,) -> None:
        self.U = np.random.normal(0,1,size=self.size)
    
    def _A(self,) -> None:
        self.A = self.U + np.random.normal(0,1,size=self.size)
        
    def _W(self,) -> None:
        self.W = self.beta*self.U + np.random.normal(0,1,size=self.size)

    def _Y(self,) -> None:
        if self.causal == True:
            self.Y = self.A+self.U + np.random.normal(0,1,size=self.size)
        else:
            self.Y = self.U + np.random.normal(0,1,size=self.size)

    def _pddata(self,) -> pd.DataFrame:
        df = pd.DataFrame({'U':self.U})
        df['A'] = self.A
        df['W'] = self.W
        df['Y'] = self.Y
        self.df = df


class Experiment4:
    def __init__(self, size,beta,causal=True) -> None:
        self.size = size
        self.causal = causal
        self.beta = beta
        self._U(); self._A(); self._W(); self._Y()
        self._pddata()
        
    def _U(self,) -> None:
        self.U = np.random.normal(0,1,size=self.size)
    
    def _A(self,) -> None:
        self.A = self.U + np.random.normal(0,1,size=self.size)
        
    def _W(self,) -> None:
        self.W = self.beta * np.tanh(self.U) + np.random.normal(0,1,size=self.size)

    def _Y(self,) -> None:
        if self.causal == True:
            self.Y = self.A + self.U + np.random.normal(0,1,size=self.size)
        else:
            self.Y = self.U + np.random.normal(0,1,size=self.size)

    def _pddata(self,) -> pd.DataFrame:
        df = pd.DataFrame({'U':self.U})
        df['A'] = self.A
        df['W'] = self.W
        df['Y'] = self.Y
        self.df = df



class Experiment5:
    def __init__(self, size,causal,name='uniform') -> None:
        self.size = size
        self.causal = causal
        self.name = name
        self._data()
        self._pddata()
        
    def _data(self,) -> None:
        if self.name =="norm":
            self.U = np.random.normal(0,1,size=self.size)
            self.A = self.U + np.random.normal(0,1,size=self.size)
            self.W = self.U + np.random.normal(0,1,size=self.size)
            if self.causal == True:
                self.Y = self.A + self.U + np.random.normal(0,1,size=self.size)
            else:
                self.Y = self.U + np.random.normal(0,1,size=self.size)
        elif self.name =="uniform":
            self.U = np.random.uniform(0,1,size=self.size)
            self.A = self.U + np.random.uniform(0,1,size=self.size)
            self.W = self.U + np.random.uniform(0,1,size=self.size)
            if self.causal == True:
                self.Y = self.A + self.U + np.random.uniform(0,1,size=self.size)
            else:
                self.Y = self.U + np.random.uniform(-1,1,size=self.size)
        elif self.name =="beta":
            self.U = np.random.beta(4,4,size=self.size)
            self.A = self.U + np.random.beta(0.5,0.5,size=self.size)
            self.W = self.U + np.random.beta(0.5,0.5,size=self.size)
            if self.causal == True:
                self.Y = self.A + self.U +np.random.beta(0.5,0.5,size=self.size)
            else:
                self.Y = self.U + np.random.beta(0.5,0.5,size=self.size)
        elif self.name =="exponential":
            self.U = np.random.exponential(1,size=self.size)
            self.A = self.U + np.random.exponential(1,size=self.size)
            self.W = self.U + np.random.exponential(1,size=self.size)
            if self.causal == True:
                self.Y = self.A + self.U +np.random.exponential(1,size=self.size)
            else:
                self.Y = self.U + np.random.exponential(1,size=self.size)
        
        

    def _pddata(self,) -> pd.DataFrame:
        df = pd.DataFrame({'U':self.U})
        df['A'] = self.A
        df['W'] = self.W
        df['Y'] = self.Y
        self.df = df


class Experiment6:
    def __init__(self, size,causal,name='uniform') -> None:
        self.size = size
        self.causal = causal
        self.name = name
        self._data()
        self._pddata()
        
    def _data(self,) -> None:
        if self.name =="norm":
            self.U = np.random.normal(0,1,size=self.size)
            self.A = self.U + np.random.normal(0,1,size=self.size)
            self.W = np.tanh(self.U) + np.random.normal(0,1,size=self.size)
            if self.causal == True:
                self.Y = self.A + self.U + np.random.normal(0,1,size=self.size)
            else:
                self.Y = self.U + np.random.normal(0,1,size=self.size)
        elif self.name =="uniform":
            self.U = np.random.uniform(0,1,size=self.size)
            self.A = self.U + np.random.uniform(0,1,size=self.size)
            self.W = np.tanh(self.U) + np.random.uniform(0,1,size=self.size)
            if self.causal == True:
                self.Y = self.A + self.U + np.random.uniform(0,1,size=self.size)
            else:
                self.Y = self.U + np.random.uniform(-1,1,size=self.size)
        elif self.name =="beta":
            self.U = np.random.beta(4,4,size=self.size)
            self.A = self.U + np.random.beta(0.5,0.5,size=self.size)
            self.W = np.tanh(self.U) + np.random.beta(0.5,0.5,size=self.size)
            if self.causal == True:
                self.Y = self.A + self.U +np.random.beta(0.5,0.5,size=self.size)
            else:
                self.Y = self.U + np.random.beta(0.5,0.5,size=self.size)
        elif self.name =="exponential":
            self.U = np.random.exponential(1,size=self.size)
            self.A = self.U + np.random.exponential(1,size=self.size)
            self.W = np.tanh(self.U) + np.random.exponential(1,size=self.size)
            if self.causal == True:
                self.Y = self.A + self.U +np.random.exponential(1,size=self.size)
            else:
                self.Y = self.U + np.random.exponential(1,size=self.size)
        
        

    def _pddata(self,) -> pd.DataFrame:
        df = pd.DataFrame({'U':self.U})
        df['A'] = self.A
        df['W'] = self.W
        df['Y'] = self.Y
        self.df = df

